Imports ADODB

Public Class Expense
    Inherits System.ComponentModel.Component

#Region " Component Designer generated code "

    Public Sub New(ByVal Container As System.ComponentModel.IContainer)
        MyClass.New()

        'Required for Windows.Forms Class Composition Designer support
        Container.Add(Me)
    End Sub
    Friend WithEvents OleDbSelectCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbInsertCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbUpdateCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbDeleteCommand1 As System.Data.OleDb.OleDbCommand
    Friend WithEvents OleDbDataAdapter1 As System.Data.OleDb.OleDbDataAdapter
                            
    Public Sub New()
        MyBase.New()

        'This call is required by the Component Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        SetupDataSetMapping()
    End Sub

    'Required by the Component Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.OleDbSelectCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbInsertCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbUpdateCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbDeleteCommand1 = New System.Data.OleDb.OleDbCommand()
        Me.OleDbDataAdapter1 = New System.Data.OleDb.OleDbDataAdapter()
        '
        'OleDbDataAdapter1
        '
        Me.OleDbDataAdapter1.DeleteCommand = Me.OleDbDeleteCommand1
        Me.OleDbDataAdapter1.InsertCommand = Me.OleDbInsertCommand1
        Me.OleDbDataAdapter1.SelectCommand = Me.OleDbSelectCommand1
        Me.OleDbDataAdapter1.UpdateCommand = Me.OleDbUpdateCommand1

    End Sub

#End Region

    Private Sub SetupDataSetMapping()
        'Setup the Mapping for the strongly typed Dataset
        Me.OleDbDataAdapter1.TableMappings.AddRange(New Data.Common.DataTableMapping() {New Data.Common.DataTableMapping("expense", "Expense", New Data.Common.DataColumnMapping() {New Data.Common.DataColumnMapping("expense_id", "ExpenseID"), New Data.Common.DataColumnMapping("expense_type", "ExpenseType"), New Data.Common.DataColumnMapping("period", "Period"), New Data.Common.DataColumnMapping("employee", "Employee"), New Data.Common.DataColumnMapping("calendar", "Calendar"), New Data.Common.DataColumnMapping("org", "Org"), New Data.Common.DataColumnMapping("proj", "Project"), New Data.Common.DataColumnMapping("expense_category", "ExpenseCategory"), New Data.Common.DataColumnMapping("description", "Description"), New Data.Common.DataColumnMapping("amount", "Amount")})})
    End Sub

    Public Function BrowseByEmployeePeriod(ByVal Employee As String, ByVal Period As Date) As ExpenseDS
        Dim Recordset As _Recordset
        Dim Expense As New TnEADO.Expense()
        Dim ExpenseInfo As New ExpenseDS()

        Recordset = Expense.BrowseByEmployeePeriod(Employee, Period)

        OleDbDataAdapter1.Fill(ExpenseInfo, Recordset, "expense")

        Return ExpenseInfo

    End Function


    Public Function Create() As ExpenseDS
        Dim Recordset As _Recordset
        Dim Expense As New TnEADO.Expense()
        Dim ExpenseInfo As New ExpenseDS()

        Recordset = Expense.Create()

        OleDbDataAdapter1.Fill(ExpenseInfo, Recordset, "expense")

        Return ExpenseInfo
    End Function


    Public Function Load(ByVal ExpenseID As Integer) As ExpenseDS
        Dim Recordset As _Recordset
        Dim Expense As New TnEADO.Expense()
        Dim ExpenseInfo As New ExpenseDS()

        Recordset = Expense.Load(ExpenseID)

        OleDbDataAdapter1.Fill(ExpenseInfo, Recordset, "expense")

        Return ExpenseInfo

    End Function


    Public Function Save(ByVal ExpenseInfo As ExpenseDS) As ExpenseDS
        Dim Recordset As _Recordset
        Dim Expense As New TnEADO.Expense()
        Dim RowsAffected As Integer

        ' Create an empty Expense Recordset
        Recordset = Expense.Create()

        ' Populate the recordset with data from the dataset
        CopyToRecordset(Recordset, ExpenseInfo)

        ' Save the expense
        RowsAffected = Expense.Save(Recordset)

        ' Load the saved expense in order to catch any changes that may have taken 
        ' place in the COM component
        If RowsAffected <> 0 Then
            ExpenseInfo = Me.Load(RowsAffected)
        Else
            ' Throw an exception
        End If

        Return ExpenseInfo

    End Function


    Public Function Add(ByVal ExpenseInfo As ExpenseDS) As ExpenseDS
        Dim Recordset As _Recordset
        Dim Expense As New TnEADO.Expense()
        Dim RowsAffected As Integer

        ' Create an empty Expense Recordset
        Recordset = Expense.Create()

        ' Populate the recordset with data from the dataset
        CopyToRecordset(Recordset, ExpenseInfo)

        ' Save the expense
        RowsAffected = Expense.Add(Recordset)

        ' Load the saved expense in order to catch any changes that may have taken 
        ' place in the COM component
        If RowsAffected <> 0 Then
            ExpenseInfo = Me.Load(RowsAffected)
        Else
            ' Throw an exception
        End If

        Return ExpenseInfo

    End Function


    Public Function Delete(ByVal ExpenseInfo As ExpenseDS) As Integer
        Dim Recordset As _Recordset
        Dim Expense As New TnEADO.Expense()
        Dim RowsAffected As Integer

        ' Create an empty Expense Recordset
        Recordset = Expense.Create()

        ' Populate the recordset with data from the dataset
        CopyToRecordset(Recordset, ExpenseInfo)

        ' Delete the time
        RowsAffected = Expense.Delete(Recordset)

        Return RowsAffected

    End Function

    Private Sub CopyToRecordset(ByRef Recordset As ADODB._Recordset, ByVal ExpenseInfo As ExpenseDS)
        With ExpenseInfo
            If .Expense.Rows.Count > 0 Then
                Recordset.Fields.Item("expense_id").Value = .Expense(0).ExpenseID
                Recordset.Fields.Item("expense_category").Value = .Expense(0).ExpenseCategory
                Recordset.Fields.Item("expense_type").Value = .Expense(0).ExpenseType
                Recordset.Fields.Item("amount").Value = .Expense(0).Amount
                Recordset.Fields.Item("calendar").Value = .Expense(0).Calendar
                Recordset.Fields.Item("description").Value = .Expense(0).Description
                Recordset.Fields.Item("employee").Value = .Expense(0).Employee
                Recordset.Fields.Item("org").Value = .Expense(0).Org
                Recordset.Fields.Item("period").Value = .Expense(0).Period
                Recordset.Fields.Item("proj").Value = .Expense(0).Project
            End If
        End With
    End Sub
End Class
